%Simulates option prices for the SVCJ model

N=10000000; %the num of simulations

nPeriods = 100; %number of simulated periods 
T=365/365;    %expiration
dt=T/nPeriods; %step size for simulation, such that dt*nPeriods=expr/366
expansion=1;

AssetPrice = 1300;
Rate = 0.05;   %annualized value: 0.05
div=Rate/2;
V0 = 0.6113/10000*365;   %annualized value: 0.0243
ThetaV = 0.6113/10000*365;  %annualized value: 0.0243
Kappa = 0.0090*365;    %annualized value: 4.2340
SigmaV = 0.1119/100*365;   %annualized value: 0.5121
RhoSV = -0.6108;

lambda=0.0035*365;   %annualized value: 1.6060
mius=-3.0804/100;   
sigmas=2.4780/100;
miuv=0.0501/100;


S=zeros(N,(nPeriods+1));
S(:,1)=AssetPrice;
V=zeros(N,(nPeriods+1));
V(:,1)=V0;

for i=2:(nPeriods+1)
    [S(:,i),V(:,i)]=SVCJEuler(Kappa,ThetaV,SigmaV,RhoSV,V(:,(i-1)),lambda,mius,sigmas,0,miuv,Rate-div,dt,S(:,(i-1)),N,1);
end

save("SVCJ_den_expansion_annual_1y_simbyEuler_spath_.mat",'S', '-v7.3');
        
%Kvec=800:10:1700;
K1 = 900:25:1000;
K2 = 1000:20:1100;
K3 = 1100:10:1200;
K4 = 1200:5:1400;
K5 = 1400:10:1500;
K6 = 1500:20:1600;
K7 = 1600:25:1700;
Kvec=[K1,K2,K3,K4,K5,K6,K7];
Kvec=unique(Kvec);

r=Rate;disc = exp(-r*dt);discc = exp(-r*T);
 [prices_put, stdErrs_put] = Price_MC_American_Strikes_func(S, disc, 0, Kvec );
% 
 prices_eo_put=Price_MC_EO_Strikes_func(S,discc,0,Kvec);
% 
 [prices_call, stdErrs_call] = Price_MC_American_Strikes_func(S, disc, 1, Kvec );
% 
 prices_eo_call=Price_MC_EO_Strikes_func(S,discc,1,Kvec);

 save("SVCJ_spd_expansion_annual_1y_simbyEuler_.mat",'prices_put','stdErrs_put','prices_eo_put','prices_call','stdErrs_call','prices_eo_call')
    
[f,xi]=ksdensity(S(1:N,(nPeriods+1)),650:1:1850);plot(xi,f);
save("SVCJ_den_expansion_annual_1y_simbyEuler_.mat",'xi','f');

